/* ============ */
/* gaptst.c	*/
/* ============ */
#include <math.h>
#include <defcodes.h>
#include <miscdefs.h>
#include <gapdefs.h>
#include <mconf.h>

#define	NUM_PROBS	100

static	GAP_DATA_STRU 	GapData;
static	INIT_DATA_STRU	InitialData;
/* ==================================================================== */
/* GapTest - Executes Gap Test per Knuth				*/
/* ==================================================================== */
void
main(void)
{
    int	    k;
    long    TotVariates = 0;
    double  DegFree;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    double  ChiSqProb[NUM_PROBS];

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\t\tG A P  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n"); fflush(NULL);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    GapData.RandFun = InitialData.RandFun;
    SetGapControls(&GapData);

    fflush(NULL);
    if (!GapData.CallStatusOK)
    {
	printf("At Least One Category Has a Cell Expectation Less"
		" Than Number Requested.\n");
	printf("The number of deficient categories is %d\n",
	    GapData.NotEnough);
	if (GapData.NumGaps < GapData.UserNumGaps)
	{
	    P(printf("For the Inputs That You Have Provided At Least %ld"
		" Gaps are Required.\n", GapData.UserNumGaps));
	}
	if (GapData.UserNumGaps > MAX_NUM_GAPS)
	{
	    printf("This Number is Greater Than the Maximum Number "
		   "Allowed (%d).\nSuggest You Reduce Gap Boundaries, "
		   "Gap Length, Number of Gaps (or All Three).\n",
		   MAX_NUM_GAPS);
	}
	if (GapData.UserCellExpect != MIN_CELL_XPCT)
	{
	    P(printf("For a Minimum of %d Samples Per Category At"
		" Least %ld Gaps are Required.\n", MIN_CELL_XPCT,
		GapData.IdealNumGaps));
	}

	printf("Run plangap.exe to Determine Appropriate Number of"
		" Gaps to be Counted.\n");
	exit(1);
    }

    DegFree = GapData.NumCategories - 1;

    /* ------------------------- */
    /* Generate Random Numbers,  */
    /* Calculate Chi-Square Data */
    /* ------------------------- */
    for (k = 0; k < NUM_PROBS; ++k)
    {
	CalcGapChiSq(&GapData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, TotVariates += GapData.TotNumGen);

	ChiSqProb[k] = chdtr(DegFree, GapData.GapChiSq);

	if (ChiSqProb[k] < 0)
	{
	    fprintf(stderr, "\nChiSqFreq(): Function chdtr() "
		"Returned Negative Probability -  Can't Happen.\n");
	}
    }

    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */
    fflush(NULL);
    KSCalc(ChiSqProb, NUM_PROBS,
		&KnPlusStat, &KnPlusProb,
 		&KnMinusStat, &KnMinusProb);

   printf("\nKolmogorov-Smirnov Statistics and Probabilities"
	" on Chi-Square Data\n");

   printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnPlusStat, 100*KnPlusProb);

   printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n\n", TotVariates);
}
